<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" >
  
  <xsl:variable name="field_res" select="AAA"   />

  <xsl:template match="/">
    <xsl:text disable-output-escaping="yes" />
    <html>
      <head>
        <title>
          Report
        </title>
        <style>
          html {font-family: arial unicode ms; sans-serif}
          h1 {text-align: center; font-size:24; color: #4886C1} h1.breakBefore {text-align: center; font-size:26; color: #4886C1;page-break-before: always}
          h2 {text-align: center; font-size:18; color: #4886C1} h2.breakBefore {text-align: center; font-size:26; color: #4886C1;page-break-before: always}
          h3 {text-align: center; font-size:18; color: #4886C1} h2.breakBefore {text-align: center; font-size:26; color: #4886C1;page-break-before: always}
          table { align; center;}
          th {text-align: center; font-size: 12; font-weight: bold; color: #4886C1}
          td {text-align: center; vertical-align: center; font-size: 9; height : 30; padding-left:5px;padding-right:5px;}
        </style>
      </head>

      <body  bgcolor = "#AFC7D1">
        <center>
        <table>
          <xsl:for-each select="FleetManagementDataSet/ViewData">
            <tr>
              <td>
                <xsl:value-of select="SerialNumber" />
              </td>
               <xsl:call-template name="TRANFORM_NAME">
                <xsl:with-param name="cp_node" select="AAA" />
              </xsl:call-template>
            </tr>
          </xsl:for-each>
        </table>
        <table>
          <tr>
            <td width ="15%"></td>
            <td>Copyright @ Motorola,Inc. All rights reserved.</td>
            <td id="DisplayDate"></td>
            <SCRIPT language="JavaScript">
              tmpDate = new Date();
              var month = tmpDate.getMonth() +1;
              var text = tmpDate.getYear()+"-"+month+ "-"+tmpDate.getDate();
              document.all.DisplayDate.innerHTML=text;
            </SCRIPT>
          </tr>
        </table>
      </center>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="TRANFORM_NAME">
    <xsl:param name="cp_node" />
    <td>
      <xsl:for-each select="field_res">
        <xsl:variable name="applicable"  select="AAA"  />
        <xsl:choose>
          <xsl:when test="$applicable =$cp_node">
            <xsl:value-of select="BBB"/>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>
    </td>
  </xsl:template>
  
</xsl:stylesheet>